/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.NotNull;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.hook.build.RawDataModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.DurabilityDisplayModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.TooltipBuilder;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.RestrictedCompoundTag;
import slimeknights.tconstruct.library.utils.Util;

public class SpaghettiModifier
extends NoLevelsModifier
implements GeneralInteractionModifierHook,
RawDataModifierHook,
TooltipModifierHook,
DurabilityDisplayModifierHook {
    private static final Lazy<ItemStack> BREAD = Lazy.of(() -> new ItemStack((ItemLike)Items.f_42406_));
    private static final Lazy<ItemStack> STEAK = Lazy.of(() -> new ItemStack((ItemLike)Items.f_42580_));
    private static final Lazy<ItemStack> BEETROOT = Lazy.of(() -> new ItemStack((ItemLike)Items.f_42732_));
    private final ResourceLocation KEY = new ResourceLocation("tinkerscalibration", "spaghetti");
    private static final Component SPAGHETTI = TConstruct.makeTranslation((String)"modifier", (String)"spaghetti");

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.GENERAL_INTERACT, ModifierHooks.RAW_DATA, ModifierHooks.TOOLTIP);
    }

    public InteractionResult onToolUse(IToolStackView tool, ModifierEntry modifier, Player player, InteractionHand hand, InteractionSource source) {
        if (source == InteractionSource.RIGHT_CLICK && tool.getPersistentData().getInt(this.KEY) > 0 && player.m_36391_(false)) {
            GeneralInteractionModifierHook.startUsing((IToolStackView)tool, (ModifierId)modifier.getId(), (LivingEntity)player, (InteractionHand)hand);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private void eat(IToolStackView tool, ModifierEntry modifier, LivingEntity entity) {
        int level = modifier.getLevel();
        if (level > 0 && entity instanceof Player) {
            Player player = (Player)entity;
            Level world = entity.m_9236_();
            ModifierUtil.foodConsumer.onConsume(player, (ItemStack)BREAD.get(), level, 0.6f);
            switch (level) {
                case 1: {
                    player.m_36324_().m_38707_(3, 0.4f);
                    break;
                }
                case 2: {
                    player.m_36324_().m_38707_(3, 0.6f);
                    ModifierUtil.foodConsumer.onConsume(player, (ItemStack)BEETROOT.get(), level, 0.6f);
                    break;
                }
                case 3: {
                    player.m_36324_().m_38707_(5, 0.6f);
                    ModifierUtil.foodConsumer.onConsume(player, (ItemStack)BEETROOT.get(), level, 0.6f);
                    ModifierUtil.foodConsumer.onConsume(player, (ItemStack)STEAK.get(), level, 0.0f);
                }
            }
            if (!player.m_7500_()) {
                tool.getPersistentData().putInt(this.KEY, tool.getPersistentData().getInt(this.KEY) - 1);
            }
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11912_, SoundSource.NEUTRAL, 1.0f, 1.0f + (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.4f);
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12321_, SoundSource.NEUTRAL, 0.5f, world.f_46441_.m_188501_() * 0.1f + 0.9f);
        }
    }

    public void onFinishUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity) {
        this.eat(tool, modifier, entity);
    }

    public int getUses(IToolStackView tool) {
        return tool.getPersistentData().getInt(this.KEY);
    }

    @NotNull
    public UseAnim getUseAction(IToolStackView tool, ModifierEntry modifier) {
        return UseAnim.EAT;
    }

    public int getUseDuration(IToolStackView tool, ModifierEntry modifier) {
        return 16;
    }

    public void addRawData(IToolStackView iToolStackView, ModifierEntry modifierEntry, RestrictedCompoundTag restrictedCompoundTag) {
        if (!iToolStackView.getPersistentData().contains(this.KEY, 3)) {
            iToolStackView.getPersistentData().putInt(this.KEY, 100);
        }
    }

    public void removeRawData(IToolStackView iToolStackView, Modifier modifier, RestrictedCompoundTag restrictedCompoundTag) {
    }

    public boolean shouldDisplay(boolean advanced) {
        return false;
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        int level = modifier.getLevel();
        if (player == null) {
            tooltip.add((Component)Component.m_237113_((String)"").m_7220_(SPAGHETTI).m_7220_(TooltipBuilder.formatPartialAmount((int)tool.getPersistentData().getInt(this.KEY), (int)100)));
            tooltip.add((Component)Component.m_237115_((String)"modifier.tinkerscalibration.spaghetti.food_level").m_7220_((Component)Component.m_237113_((String)Util.COMMA_FORMAT.format((long)level < 3L ? 3L : 5L)).m_130938_(style -> style.m_178520_(-2661276))));
            tooltip.add((Component)Component.m_237115_((String)"modifier.tinkerscalibration.spaghetti.saturation_level").m_7220_((Component)Component.m_237113_((String)Util.COMMA_FORMAT.format((long)level < 3L ? (double)((float)level * 1.2f + 1.2f) : 6.0)).m_130938_(style -> style.m_178520_(-8871731))));
            if (level > 1) {
                tooltip.add((Component)Component.m_237115_((String)"modifier.tinkerscalibration.spaghetti.sauce").m_130938_(style -> style.m_178520_(-8042548)));
                if (level > 2) {
                    tooltip.add((Component)Component.m_237115_((String)"modifier.tinkerscalibration.spaghetti.meat").m_130938_(style -> style.m_178520_(-8042548)));
                }
            }
        }
    }

    @Nullable
    public Boolean showDurabilityBar(IToolStackView iToolStackView, ModifierEntry modifierEntry) {
        return this.getUses(iToolStackView) < 100 ? Boolean.valueOf(true) : null;
    }

    public int getDurabilityRGB(IToolStackView iToolStackView, ModifierEntry modifierEntry) {
        float f = Math.max(0.0f, (float)this.getUses(iToolStackView) / 100.0f);
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public int getDurabilityWidth(IToolStackView tool, ModifierEntry modifier) {
        int uses = this.getUses(tool);
        return uses > 0 ? DurabilityDisplayModifierHook.getWidthFor((int)uses, (int)100) : 0;
    }
}

